﻿IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Cbtes_Descrip_SinTrans') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION CF_Cbtes_Descrip_SinTrans
END
GO
CREATE FUNCTION [dbo].[CF_Cbtes_Descrip_SinTrans](   @pComprobante_Ult_Nro	INT,
													@pDescrip_Corta			CHAR(4),
													@pLetra					VARCHAR(3),
													@pId_Sucursal			SMALLINT,
													@pCant_Dig_Cbtes		INT,
													@pCompromete_Remitos	SMALLINT,
													@pCant_Dig_Rem			INT,
													@pId_Sucursal_Compra	SMALLINT,
													@pCompromete_Compras	SMALLINT)
RETURNS VARCHAR(100)	
AS
BEGIN

DECLARE @Descripcion			VARCHAR(100)
DECLARE @Comprobante_Nro_Char	VARCHAR(9)
DECLARE @Sucursal_Char			VARCHAR(5)

IF(@pCant_Dig_Rem <> 0 AND @pCompromete_Remitos IN (1,-1))
BEGIN
	SET @pCant_Dig_Cbtes = @pCant_Dig_Rem
END

IF(@pCompromete_Compras IN (1, -1))
BEGIN
   SET @pId_Sucursal	= @pId_Sucursal_Compra
END

SET @Sucursal_Char			= (SELECT REPLICATE('0',5-LEN(RTRIM(@pId_Sucursal))) + RTRIM(@pId_Sucursal))

/*=====================================================================================================*/

IF(@pCant_Dig_Cbtes > 4)
BEGIN
	SET @Comprobante_Nro_Char	= (SELECT REPLICATE('0',@pCant_Dig_Cbtes-LEN(RTRIM(@pComprobante_Ult_Nro))) + RTRIM(@pComprobante_Ult_Nro))
	
END
ELSE
BEGIN
	SET @Comprobante_Nro_Char	= (SELECT REPLICATE('0',4-LEN(RTRIM(@pComprobante_Ult_Nro))) + RTRIM(@pComprobante_Ult_Nro))
END

/*=====================================================================================================*/

SET @Descripcion = (@pDescrip_Corta + ' ' + @pLetra + ' ' + @Sucursal_Char + '-' + @Comprobante_Nro_Char);

RETURN ISNULL(@Descripcion, '')
END  
